/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWMilestoneDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7460L;
    protected String name = null;
    private String message = null;
    private int level = 1;
    private VWWorkflowDefinition myWorkflow;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-10-01 17:28:17 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/7 $";
    }

    protected VWMilestoneDefinition(VWWorkflowDefinition theWorkflow, String theName) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWMilestoneDefinitionInvalidWorkflow", "theWorkflow is invalid, (null).");
        }
        this.myWorkflow = theWorkflow;
        this.setName(theName);
    }

    protected VWMilestoneDefinition(String theName, int theLevel, String theMessage) throws VWException {
        this.setName(theName);
        this.setLevel(theLevel);
        this.setMessage(theMessage);
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWMilestoneDefinitionInvalidName", "theName is invalid, (null or zero length).");
        }
        if (theName.equals(this.name)) {
            return;
        }
        VWWorkflowDefinition wflDef = this.getWorkflowDefinition();
        if (wflDef != null && wflDef.isExistingMilestoneName(theName)) {
            throw new VWException("vw.api.VWMilestoneDefinitionNameAlreadyExists", "theName is invalid, (a milestone named {0} already exists in this workflow definition).", theName);
        }
        this.name = theName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String theMessage) throws VWException {
        this.message = theMessage;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int theLevel) throws VWException {
        if (theLevel < 1 || theLevel > 99) {
            throw new VWException("vw.api.VWMilestoneDefinitionInvalidLevel", "Invalid level value {0}.", String.valueOf(theLevel));
        }
        this.level = theLevel;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWMilestoneDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<Milestone");
        if (this.name != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"");
        }
        if (this.message != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Message=\"" + VWXMLHandler.toXMLString(this.message) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "Level=\"" + String.valueOf(this.level) + "\"");
        theBuffer.append("/>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWMilestoneDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<Milestone");
        if (this.name != null) {
            theBuffer.append(" Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"");
        }
        theBuffer.append(" Level=\"" + String.valueOf(this.level) + "\"");
        if (this.message != null) {
            theBuffer.append("\n" + indentB + "Message=\"" + VWXMLHandler.toXMLString(this.message) + "\"");
        }
        theBuffer.append("/>\n");
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        if (this.myWorkflow == null) {
            throw new VWException("vw.api.VWMilestoneDefinitionNullWorkflowRef", "No reference to containing workflow definition, runtime milestone definition, cannot validate.");
        }
        VWWorkflowSignature myWflSignature = this.myWorkflow.getWorkflowSignature(validationContext);
        VWWorkflowSignature myBaseWflSignature = this.myWorkflow.getBaseWorkflowSignature(validationContext);
        if (this.message != null && this.message.compareTo("") != 0) {
            VWCompiledExpr compRes = new VWCompiledExpr();
            String[] theErrorStrings = VWExpr.compileVWExpr(this.message, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int i = 0; i < errorCount; ++i) {
                    VWString theMessage2 = new VWString("vw.api.VWMilestoneDefinitionSyntaxError", "{0}", theErrorStrings[i]);
                    VWValidationError theError2 = new VWValidationError(8, 1, this.name, this.message, theMessage2.toString(), null);
                    validationContext.addValidationError(theError2);
                }
            } else if (compRes.getResultIsArray() || compRes.getResultType() != 2) {
                VWString theMessage3 = new VWString("vw.api.VWMilestoneDefinitionMessageNotString", "Milestone message expression must be a string, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()), compRes.getResultIsArray() ? "[ ]" : "");
                VWValidationError theError3 = new VWValidationError(8, 1, this.name, this.message, theMessage3.toString(), null);
                validationContext.addValidationError(theError3);
            }
        }
        if (this.message != null && this.message.compareTo("") == 0) {
            theMessage = new VWString("vw.api.VWMilestoneDefinitionEmptyMessageValue", "Milestone message expression has no value");
            theError = new VWValidationError(8, 1, this.name, this.message, theMessage.toString(), null);
            validationContext.addValidationError(theError);
        }
        if (this.message == null) {
            theMessage = new VWString("vw.api.VWMilestoneDefinitionMessageHasNullValue", "Milestone message expression expression is null");
            theError = new VWValidationError(8, 1, this.name, null, theMessage.toString(), null);
            validationContext.addValidationError(theError);
        }
    }

    protected VWWorkflowDefinition getWorkflowDefinition() {
        return this.myWorkflow;
    }

    protected void setWorkflow(VWWorkflowDefinition theWorkflow) {
        this.myWorkflow = theWorkflow;
    }

    public Object clone() {
        try {
            VWMilestoneDefinition mx = (VWMilestoneDefinition)super.clone();
            return mx;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VWMilestoneDefinition) {
            VWMilestoneDefinition tempObj = (VWMilestoneDefinition)obj;
            if (!this.name.equals(tempObj.getName())) {
                return false;
            }
            if (this.message == null ? tempObj.getMessage() != null : !this.message.equals(tempObj.getMessage())) {
                return false;
            }
            return this.level == tempObj.getLevel();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.level;
        result = 32 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 32 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    protected VWSession getSession() throws VWException {
        if (this.myWorkflow != null) {
            return this.myWorkflow.getSession();
        }
        return null;
    }
}

